require( "scripts/style.lua" );






NameFont = {
  standardFont,
  24,
  BorderColor
};

HeaderFont = {
  standardFont,
  48,
  BorderColor
};

ButtonX = kCenter;
ButtonY = 112;
ButtonYSpace = 27;


NameButtonGraphics = {
	"buttons/select_none.png",
	"buttons/select_highlight.png",
	"buttons/select_field.png",
	"buttons/select_highlight.png"
};	

NameStyle= {
	type = kRadio,
	flags = kHAlignCenter + kVAlignCenter,
	font = StandardButtonFont,
	graphics = NameButtonGraphics,
	sound = kDefaultButtonSound
};

function MakeSlot(i)
	return Group{
		Button{
				name="button"..i,
				label="name",
				x=ButtonX,
				y=ButtonY+(ButtonYSpace*i),
				command = 
					function()
						EnableWindow("chooseok", true);
						EnableWindow("delete", true);
						EnableWindow("editname", not PFUserAccount(i));
					end
				
				
		},
		Bitmap
		{
			image = "hiscore/p1icon.png",
			name = "p1_"..i,
			x=70,y=ButtonY+(ButtonYSpace*i)+5,
		}
	};
end

function MakePlayerSlots()
	local windows = {};
	for i=0,9 do
		table.insert(windows, MakeSlot(i));
	end;
	return Group(windows);
end

originalUser = GetCurrentUser();

MakeDialog
{
	PopThroughBitmap
	{ 
		image="backgrounds/longdialog",
		x=kCenter,
		y=kCenter,
		
		ChoosePlayerWindow
		{
			x = 0, y = 0, w=kMax, h=kMax,
			
			Text
			{
				font = HeaderFont,
				name = "selectaplayer",
				x=0,y=30,w=kMax,h=kMax,
				flags = kHAlignCenter + kVAlignTop,
				label = "selectaplayer"
			};
			
			SetStyle(SmallButtonStyle);
			
			Button{
				x=30,
				y=75,
				name="newplayer",
				label="newplayer",
				type = kPush,
				command =
					function()
						SetSessionSetting('creatingnewuser', 'true');
						oldIndex = GetCurrentUser();
						SetCurrentUser(-1, false);
						if (LoginSystemEnabled()) then
							numUsers = GetNumUsers();
							Login(InAnonymousArea(), true);
							if (numUsers ~= GetNumUsers()) then
								SetPlayerChoices();
								if (IsLoggedIn(false)) then
									originalUser = GetNumUsers() - 1;
								end
							else
								SetCurrentUser(oldIndex, false);
							end
						else
							name = UserNameEnterTextDialog('');
							if (not(name == nil)) then
								CreateNewUser(name);
								SetPlayerChoices();
							else
								SetCurrentUser(oldIndex, false);
							end
						end
						SetSessionSetting('creatingnewuser', 'false');
						if (GetCurrentUser() == -1) then
							SetCurrentUser(oldIndex, false);
						elseif (GetCurrentUser() ~= oldIndex) then
							PopModal("scripts/chooseplayer.lua");
							if (not LoginSystemEnabled()) then
								PostMessage( CreateNamedMessage( kPlayerLoggedIn, GetCurrentUserName() ) );
							end
						end
						
					end
			};
			
			Button{
				x=148,
				y=75,
				name="editname",
				label="",
				type = kPush,
				label="editname",
				command =
					function()
						index = GetCurrentSelectedUser();
						name = UserNameEnterTextDialog(GetSelectedPlayerName());
						if (name ==  nil) then
							return;
						end
						
						nameInUse = false;
						for i=0,GetNumUsers() do
							if GetIndexedUserName(i) == name then
								nameInUse = true;
								break;
							end
						end
						if (nameInUse) then
							DisplayDialog {
								'scripts/ok.lua',
								body='nameinuse',
								title=''
							};
						else
							SetUserName(index, name);
							SetPlayerChoices();
						end
					end
			};
				
			Button{
				x=267,
				y=75,
				name="delete",
				label="deleteplayer",
				type = kPush,
				command =
					function()
						result = DisplayDialog { 
							"scripts/yesno.lua", 
							body ="deleteconfirm",
							title = "",
							popthrough = true
						};
						if (result=='yes') then
							userNum = GetCurrentSelectedUser();
							DeleteUser(userNum)
							SetPlayerChoices()
						end
					end
				
			};
			
			SetStyle(NameStyle);
			BeginGroup();
			MakePlayerSlots();
			SetStyle(DefaultStyle);
			
			SetStyle(StandardButtonStyle);
			Button{
				x=kCenter,
				y=395,
				name="chooseok",
				label="ok",
				type = kPush,
				command = 
					function()
						userNum = GetCurrentSelectedUser();
						if (userNum ~= originalUser) then
							Logout();
						end
						SetCurrentUser(userNum, false);
						PopModal("scripts/chooseplayer.lua");
						if (not LoginSystemEnabled()) then
							PostMessage( CreateNamedMessage( kPlayerLoggedIn, GetCurrentUserName() ) );
						end
					end
				
			};
			
			Button {
				x=kCenter,
				y=395,
				name="choosecancel",
				label="cancel",
				type = kPush,
				command = 
					function()
						PopModal("scripts/chooseplayer.lua");
					end
			};			
			
			SetStyle(DefaultStyle);
		}
	}
}

SetPlayerChoices();



